@extends('user.layout.app')

@section('content')
<div class="banner row no-margin" style="background-image: url('{{ asset('asset/img/banner-bg.jpg') }}');">
    <div class="banner-overlay"></div>
    <div class="container pad-60">
        <div class="col-md-8">
            <h2 class="banner-head"><span class="strong">Work that puts you first</span><br>Drive when you want, make what you need</h2>
        </div>
        <div class="col-md-4">
            <div class="banner-form">
                <div class="row no-margin fields">
                    <div class="left">
                    	<img src="{{asset('asset/img/taxi-app.png')}}">
                    </div>
                    <div class="right">
                        <a href="{{url('login')}}">
                            <h3>Ride with {{Setting::get('site_title','6ixTaxi')}}</h3>
                            <h5>SIGN IN <i class="fa fa-chevron-right"></i></h5>
                        </a>
                    </div>
                </div>

                <div class="row no-margin fields">
                    <div class="left">
                    	<img src="{{asset('asset/img/taxi-app.png')}}">
                    </div>
                    <div class="right">
                        <a href="{{url('provider/login')}}">
                            <h3>Sign in to drive</h3>
                            <h5>SIGN IN <i class="fa fa-chevron-right"></i></h5>
                        </a>
                    </div>
                </div>

                <!-- <p class="note-or">Or <a href="{{ url('login') }}">sign in</a> with your rider account.</p> -->
            </div>
        </div>
    </div>
</div>

<div class="row white-section pad-60 no-margin">
    <div class="container">
        
        <div class="col-md-4 content-block small">
             <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/driving-license.png')}}"></div>
            <h2>Set your own schedule</h2>
            <div class="title-divider"></div>
            <p>Be your own boss. Drive with 6ix anytime,day or night all year long. </p>

            <!--<p>You can drive with {{ Setting::get('site_title', '6ixTaxi') }} anytime, day or night, 365 days a year. When you drive is always up to you, so it never interferes with the important things in your life.</p>-->
        </div>
    </div>

        <div class="col-md-4 content-block small">
             <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/destination.png')}}"></div>
            <h2>Make more at every turn</h2>
            <div class="title-divider"></div>
            <p>Take home cash everyday payments received by credit cards deposited weekly, or a check can be picked up at the head office. </p>
            <p>Trip fares start with a base amount, then increase with time and distance. And when demand is higher than normal, drivers make more.</p>
        </div>
    </div>

        <div class="col-md-4 content-block small">
             <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/taxi-app.png')}}"></div>
            <h2>Let the app lead the way</h2>
            <div class="title-divider"></div>
            <p>Just tap and go. You’ll get turn-by-turn directions, and tools to help you earn more, and 24/7 support -all available through the app.</p>
            <!--<p>Just tap and go. You’ll get turn-by-turn directions, tools to help you make more, and 24/7 support—all available right there in the app.</p>-->
        </div>
    </div>

    </div>
</div>

<div class="row gray-section no-margin full-section">
    <div class="container">                
        <div class="col-md-6 content-block">
            <div class="icon"><img src="{{asset('asset/img/taxi-car.png')}}"></div>
            <h3>About the app</h3>
            <h2>Designed just for drivers</h2>
            <div class="title-divider"></div>
            <p>6ixtaxi driver app matches you with passengers who request rides through our app, and passengers can pay automatically through the app, or with cash. You’ll get information about your rider, and direction to their location and destination. When the trip is over, pick up another request while you’re on the road, or sign off at any time. </p>
            <!--<p>When you want to make money, just open the app and you’ll start to receive trip requests. You’ll get information about your rider and directions to their location and destination. When the trip is over, you’ll receive another nearby request. And if you're ready to get off the road, you can sign off at any time.</p>-->
            <a class="content-more more-btn" href="{{url('login')}}">SEE HOW IT WORKS <i class="fa fa-chevron-right"></i></a>
        </div>
        <div class="col-md-6 full-img text-center" style="background-image: url({{ asset('asset/img/driver-car.jpg') }});"> 
            <!-- <img src="img/anywhere.png"> -->
        </div>
    </div>
</div>

<div class="row white-section pad-60 no-margin">
    <div class="container">
        
        <div class="col-md-4 content-block small">
            <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/budget.png')}}"></div>
            <h2>Rewards</h2>
            <div class="title-divider"></div>
            <p>Reward yourself with discounts on fuel, vehicle maintenance, cell phone bills and more. Reduce your daily expense and take home extra cash </p>
            <!--<p>You’re in the driver’s seat. So reward yourself with discounts on fuel, vehicle maintenance, cell phone bills, and more. Reduce your daily expenses and take home extra cash.</p>-->
        </div></div>

        <div class="col-md-4 content-block small">
            <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/driving-license.png')}}"></div>
            <h2>Requirements</h2>
            <div class="title-divider"></div>
            <p>You must meet the minimum requirements and complete a safety screening online.</p>
            <p><a href="">Learn More<a/></p>
            <!--<p>Know you’re ready to hit the road. Whether you’re driving your own car or a commercially-licensed vehicle, you must meet the minimum requirements and complete a safety screening online.</p>--> 
        </div></div>

        <div class="col-md-4 content-block small">
            <div class="box-shadow">
                <div class="icon"><img src="{{asset('asset/img/seat-belt.png')}}"></div>
            <h2>Safety</h2>
            <div class="title-divider"></div>
            <p>24/7 driver support - contact our support team with any issues on and off the road-, and Insurance coverage All riders verified so you know who you’re picking up and so will we.</p>
            <!--<p>When you drive with {{ Setting::get('site_title', '6ixTaxi') }}, you get 24/7 driver support and insurance coverage. And all riders are verified with their personal information and phone number, so you’ll know who you’re picking up and so will we.</p>-->
        </div></div>

    </div>
</div>
            
<div class="row find-city no-margin">
    <div class="container">
        <div class="col-md-12 center content-block">
            <div class="box-shadow">
                <div class="pad-60 ">
        <h2>Start making money</h2>
        <p>Ready to make money? The first step is to sign up online.</p>
<a class="content-more more-btn" href="{{url('login')}}">START DRIVE NOW <i class="fa fa-chevron-right"></i></a>
        <!-- <button type="submit" class="full-primary-btn drive-btn">START DRIVE NOW</button> -->
    </div>
</div>
</div>
    </div>
</div>

<!-- <div class="footer-city row no-margin" style="background-image: url({{ asset('asset/img/footer-city.png') }});"></div> -->
@endsection